/**
 * \file: mlink_wfd_touch_internals.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MLINK WiFi-Display Touch Adapter
 *
 * \component: mlink
 *
 * \author: V.Deety / RBEI/ECF3 / venkatasaiganesh.deety@in.bosch.com
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include "mlink_wfd_touch_internals.h"

/*static*/WfdTouch* WfdTouch::gpSelf = NULL;

/*static*/WfdTouch* WfdTouch::getInstance(void)
{
    if (!gpSelf)
    {
        gpSelf = new WfdTouch();
    }

    return gpSelf;
}

/*static*/void WfdTouch::deleteInstance(void)
{
    if (gpSelf)
    {
        delete gpSelf;
        gpSelf = NULL;
    }
}

WfdTouch::WfdTouch()
{
    ctx = NULL;
}

WfdTouch::~WfdTouch()
{
    ctx = NULL;
}

bool WfdTouch::initialize(VNCWiFiDisplaySDK* pWFDSDK, VNCWiFiDisplaySink* pWFDSink, void* SessionCtx)
{
    ctx = new ml_wfd_touch_context;
    ctx->pWFDSDK = pWFDSDK;
    ctx->pWFDSink = pWFDSink;

    mTouchFacade = move(std::unique_ptr<WaylandFacade>((new WaylandFacade(SessionCtx))->
            setDisplaySize(1, 1)->
            setFingerNum(2)));

    if(!mTouchFacade->initialize(this))
    {
        printf("Failed to initialize touch facade \n");
        return false;
    }
    return true;
}

void WfdTouch::shutdown()
{
    delete ctx;
    mTouchFacade->deinitialize();
}

void WfdTouch::send_touch(void)
{
    VNCTouchDescriptor * touch_ptr = NULL;
    VNCWiFiDisplayError error;
    int size = 0;

    if(ctx->touch_valid[0])
      {
        touch_ptr= &ctx->touch_desc[0];
        if(ctx->touch_valid[1])
          {
            size = 2;
          }
        else
          {
            size = 1;
          }
      }
    else if(ctx->touch_valid[1])
      {
        touch_ptr= &ctx->touch_desc[1];
        size = 1;
      }
    error = (ctx->pWFDSDK->vncWiFiDisplaySinkSendMirrorLinkTouchEvent)(ctx->pWFDSink,
               touch_ptr, size, 0, 0);
    printf("Touch event is sent with error = %d\n", error);

}

void WfdTouch::onTouch(TouchEvent inEvent)
{
    printf(" Touch Event Type: %d, Id: %d x: %f y: %f\n",
            inEvent.eventType,inEvent.fingerId, inEvent.xRelative, inEvent.yRelative);
    int pointer_x = inEvent.xRelative;
    int pointer_y = inEvent.yRelative;

    switch (inEvent.eventType)
    {
    case TouchEvent::down:
    {
        if(inEvent.fingerId >= 0 && inEvent.fingerId < MLINK_WL_MAX_TOUCHPOINTS)
          {
            ctx->touch_desc[inEvent.fingerId].location.x = pointer_x;
            ctx->touch_desc[inEvent.fingerId].location.y = pointer_y;
            ctx->touch_desc[inEvent.fingerId].pressure = 1;
            ctx->touch_desc[inEvent.fingerId].buttonMask = VNCPointerDeviceButtonLeft;
            ctx->touch_desc[inEvent.fingerId].identifier = inEvent.fingerId;
            ctx->touch_valid[inEvent.fingerId] = 1;
            send_touch();
          }
        break;
    }
    case TouchEvent::move:
    {
        if(inEvent.fingerId >= 0 && inEvent.fingerId < MLINK_WL_MAX_TOUCHPOINTS)
          {
            ctx->touch_desc[inEvent.fingerId].location.x = pointer_x;
            ctx->touch_desc[inEvent.fingerId].location.y = pointer_y;
            ctx->touch_desc[inEvent.fingerId].pressure = 1;
            ctx->touch_desc[inEvent.fingerId].buttonMask = VNCPointerDeviceButtonLeft;
            ctx->touch_desc[inEvent.fingerId].identifier = inEvent.fingerId;
            ctx->touch_valid[inEvent.fingerId] = 1;
            send_touch();
          }

        break;
    }
    case TouchEvent::up:
    {
        if(inEvent.fingerId >= 0 && inEvent.fingerId < MLINK_WL_MAX_TOUCHPOINTS)
          {
            ctx->touch_desc[inEvent.fingerId].pressure = 0;
            ctx->touch_desc[inEvent.fingerId].buttonMask = VNCPointerDeviceButtonLeft;
            ctx->touch_desc[inEvent.fingerId].identifier = inEvent.fingerId;
            send_touch();
            ctx->touch_valid[inEvent.fingerId] = 0;
          }
        break;
    }

    default:
        break;
    }
}

void WfdTouch::onTouchError(int inError)
{
    inError = inError;
    printf("An Error has occured \n");
}

void WfdTouch::onLogging(UspiLogLevel inLogLevel, const std::string& inLogString)
{
    // todo implement a logging mechanism consistent with the rest of the component
    (void)inLogLevel;
    (void)inLogString;
}
